/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPHumanAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.MosPUserDto;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.system.vo.FirstHumanAccountCardVo;

public class FirstHumanAccountCardAction extends MosPHumanAction {

	// R}h
	private static final String CMD_FIRST_HUMAN_ACCOUNT_CARD_SHOW   = "S2410";
	private static final String CMD_FIRST_HUMAN_ACCOUNT_CARD_INSERT = "S2417";

	/**
	 * RXgN^
	 */
	public FirstHumanAccountCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		FirstHumanAccountCardVo vo = new FirstHumanAccountCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// v_ẼZbg
		setPulldownList(vo);
		// R}h̏
		if (cmd.equals(CMD_FIRST_HUMAN_ACCOUNT_CARD_SHOW)) {
			// l\
			setMode(vo);
		} else if (cmd.equals(CMD_FIRST_HUMAN_ACCOUNT_CARD_INSERT)) {
			// VKo^
			insert(vo);
			// ꗗ\
			setNextCmd(AccountMasterListAction.CMD_ACCOUNT_MASTER_LIST_RE_SEARCH);
			// T[ubg֓]
			setUrl(MospConst.URL_SRV);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * v_E̐ݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setPulldownList(FirstHumanAccountCardVo vo) throws Exception {
		vo.aryPltOfficeAll 	= getOfficeArrayAll();
		vo.aryPltSectionAll	= getSectionArrayAll();
		vo.aryPltPosition	= getPositionPltArray();
		// ƏAAEꌏo^ĂȂꍇ
		if (vo.aryPltOfficeAll.length == 0 	||
				vo.aryPltPosition.length == 0 	||
				vo.aryPltSectionAll.length == 0
		) {
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_CODE, ""));
		}
	}

	/**
	 * VKo^
	 * @param vo
	 * @throws Exception
	 */
	private void insert(FirstHumanAccountCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// p[^̑ÓmF
		vo.validate();
		// l{pDAO
		prepareHumanBasisDao();
		// }X^f[^݊mF
		chkDuplicate(mKihonDao.findForKey(vo.getTxtKCode()), vo);
		// o^
		String message = regist(vo);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(message);
	}

	/**
	 * o^
	 * @param vo ΏVO
	 * @return bZ[W
	 * @throws Exception
	 */
	private String regist(FirstHumanAccountCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DTO
		mKihonDto = new MKihonDto();
		mKihonDto.setKCode(vo.getTxtKCode());
		mKihonDto.setSimei(vo.getTxtUserName());
		mKihonDto.setSCode(vo.getPltSection());
		mKihonDto.setYCode(vo.getPltPosition().split(CommonConst.STR_TIME_SEPARATOR)[0]);
		mKihonDto.setTokyu(vo.getPltPosition().split(CommonConst.STR_TIME_SEPARATOR)[1]);
		mKihonDto.setJCode(vo.getPltOffice());
		mKihonDto.setKnKubun(String.valueOf(CommonConst.RETIREMENT_FLAG_OFF));
		// ݊mF
		String message = "";
		if (!chkExistDto(mKihonDao.findForUpdate(mKihonDto.getKCode()))) {
			// VKo^
			mKihonDao.insert(mKihonDto);
			// l{擾
			findHumanBasisInfo(mKihonDto.getKCode(), false);
			// [U[擾
			MosPUserDao mospuserDao = new MosPUserDao();
			mospuserDao.initDao(cfg, cmd, aspUser, user, conn);
			// [U
			if (!chkExistDto(mospuserDao.findForUpdate(mKihonDto.getKCode()))) {
				// [U[̍쐬
				MosPUserDto mospuserDto = new MosPUserDto();
				mospuserDto.setUserId(mKihonDto.getKCode());
				mospuserDto.setPassword(MospUtility.getDigest(MospUtility.getDigest(mKihonDto.getKCode())));
				mospuserDto.setKCode(mKihonDto.getKCode());
				mospuserDto.setUserName(mKihonDto.getSimei());
				mospuserDto.setAuthority(CommonConst.AUTHORITY_HUMAN);
				mospuserDto.setChangePass(new Date());
				mospuserDto.setDataLevel(CommonConst.DATA_DEFAULT_LEVEL);
				mospuserDao.insert(mospuserDto);
				message = MospUtility.getMessage(msg, MospConst.MSG_INSERT, "");
			} else {
				message = MospUtility.getMessage(msg, MospConst.MSG_DUPLICATE, "");
			}
		} else {
			message = MospUtility.getMessage(msg, MospConst.MSG_DUPLICATE, "");
		}
		return message;
	}

	/**
	 * [hݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setMode(FirstHumanAccountCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// DAȌ
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<MosPUserDto> listHuman = dao.findAllMosPUser();
		// HUMANmF
		boolean hasAuth = false;
		String[][] aryHuman = getConfArray(CommonConst.CONF_ID_HUMAN);
		for (Iterator iter = listHuman.iterator(); iter.hasNext();) {
			MosPUserDto dto = (MosPUserDto) iter.next();
			for (int i = 0; i < aryHuman.length; i++) {
				if (aryHuman[i][0].equals(dto.getAuthority())) {
					hasAuth = true;
					break;
				}
			}
		}
		if (hasAuth) {
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DUPLICATE, ""));			
			vo.setMode(FirstHumanAccountCardVo.MODE_VIEW);
		} else {
			vo.setMode(FirstHumanAccountCardVo.MODE_INSERT);
		}
	}

}
